# Disknet Setup using Apache

## install dependencies and clone files
1. install apache2 and apache2-dev
1. install MySQL 5.7
1. Install Python 3.7 and Pip3
1. Install Pipenv
1. clone repository to `/var/www/html/`
1. create secret_key_disknet.txt at /etc/
1. install all packages via pipenv
1. install Pillow systemwide (```$sudo pip3 install Pillow```) otherwise Image-Upload will yield apache 500-Errors for images
1. install ```$sudo apt-get install python3.XX-dev libmysqlclient-dev```
1. on mac: install myscqlclient-python (https://github.com/PyMySQL/mysqlclient-python)
    - make Edits under "Note about bug of MySQL Connector/C on macOS" (using vim on "which mysql_config")
    - check for problems with openssl via ```brew info openssl``` and export ```LDFLAGS``` and ```CPPFLAGS```
    - ```export LDFLAGS="-L/usr/local/opt/openssl/lib"```
    - ```export CPPFLAGS="-I/usr/local/opt/openssl/include"```
    - try to install manually --> enter pipenv shell and ```pip install mysqlclient```
1. adjust admin link file in `disknet/static` to point at right virtualenv (```$sudo ln -s /home/[USERNAME]/.local/share/virtualenvs/[NAME_VIRTUALENV]//lib/python3.7/site-packages/django/contrib/admin/static/admin/```)
1. add ```__init__.py``` to ```mysite/settings/``` with (depending if on local/dev/production environment):
	- ```from .local import *```
	- ```from .development import *```
	- ```from .production import *```
1. adjust database credentials in respective (dev/local/production) settings file
1. For def/local servers ensure that setting file has:
    * ```CSRF_COOKIE_SECURE = False```
	* ```SESSION_COOKIE_SECURE = False```
    * ```DEBUG = True``` 

## install apache with mod_wsgi
1. Download mod_wsgi from https://github.com/GrahamDumpleton/mod_wsgi/releases
1. Unzip
1. ````$sudo ./configure  --with-python=`which python3.7` ````
1. ````$sudo make````
1. ````$sudo make install````
1. ````$sudo /etc/init.d/apache2 restart````
1. enable mod_rewrite either by... 
    1. linking it from mods-enabled to mods-available using ```$ln -l [path]```(check existing links’ paths)
    1. ```$sudo a2enmod rewrite```
1. on Live Server: enable SSL-mod (for https) mod_ssl via ```$sudo a2enmod ssl```
## configure apache
1. adapt VirtualHost config and directory of letsencrypt certificate towards path of python virtualenv:
```<IfModule mod_ssl.c>
<VirtualHost *:443>
    # This is name based virtual hosting. So place an appropriate server name
    #   here. Example: django.devsrv.local
    ServerName disknet.iism.kit.edu
    ServerAdmin webmaster@localhost

    # This alias makes serving static files possible.
    #   Please note, that this is geared to our settings/common.py
    #   In production environment, you will propably adjust this!
    Alias /static/  /var/www/html/disknet/disknet/static/

    # This alias makes serving media files possible.
    #   Please note, that this is geared to our settings/common.py
    #   In production environment, you will propably adjust this!
    Alias /media/  /var/www/html/disknet/media/

    # Insert the full path to the wsgi.py-file here
    WSGIScriptAlias /   /var/www/html/disknet/mysite/wsgi.py

    # PROCESS_NAME specifies a distinct name of this process
    #   see: https://code.google.com/p/modwsgi/wiki/ConfigurationDirectives#WSGIDaemonProcess
    # PATH/TO/PROJECT_ROOT is the full path to your project's root directory,
    #   containing your project files
    # PATH/TO/VIRTUALENV/ROOT: If you are using a virtualenv specify the full
    #   path to its directory.
    #   Generally you must specify the path to Python's site-packages.
    WSGIDaemonProcess   disknet  python-path=/var/www/html/disknet:/home/admin_user/.local/share/virtualenvs/disknet-R4q9uhir/lib/python3.7/site-packages

    # PROCESS_GROUP specifies a distinct name for the process group
    #   see: https://code.google.com/p/modwsgi/wiki/ConfigurationDirectives#WSGIProcessGroup
    WSGIProcessGroup    disknet

    # Serving static files from this directory
    #   Please note, that this is geared to our settings/common.py
    #   In production environment, you will propably adjust this!
    <Directory /var/www/html/disknet/disknet/static>
        Options -Indexes
        Order deny,allow
        Allow from all
    </Directory>

    # Serving media files from this directory
    #   Please note, that this is geared to our settings/common.py
    #   In production environment, you will propably adjust this!
    <Directory /var/www/html/disknet/media>
        Options -Indexes
        Order deny,allow
        Allow from all
    </Directory>

    LogLevel warn

    # PROJECT_NAME is used to seperate the log files of this application
    ErrorLog    ${APACHE_LOG_DIR}/disknet_error.log
    CustomLog   ${APACHE_LOG_DIR}/disknet_access.log combined
SSLCertificateFile /etc/letsencrypt/live/disknet.iism.kit.edu/fullchain.pem
SSLCertificateKeyFile /etc/letsencrypt/live/disknet.iism.kit.edu/privkey.pem
Include /etc/letsencrypt/options-ssl-apache.conf
</VirtualHost>
</IfModule>
```
1. save as `default-ssl.conf` in  `/etc/apache2/sites-available/`
1. adapt default following `000-default.conf`:

``` 
<VirtualHost *:80>
    # This is name based virtual hosting. So place an appropriate server name
    #   here. Example: django.devsrv.local
    ServerName disknet.iism.kit.edu
    
RewriteEngine on
RewriteCond %{SERVER_NAME} =disknet.iism.kit.edu
RewriteRule ^ https://%{SERVER_NAME}%{REQUEST_URI} [END,NE,R=permanent]
</VirtualHost>
```
1. save to `/etc/apache2/sites-available/`
1. create a link to `default-ssl.conf` and `000-default.conf in` `/etc/apache2/sites-enabled/` from sites-available with ```$ln -s [path]``` (check existing links’ paths)
1. Note: For def servers: only adjust 000-default.conf like this:
```<VirtualHost *:80>
    # This is name based virtual hosting. So place an appropriate server name
    #   here. Example: django.devsrv.local
    ServerName dev.disknet.iism.kit.edu
    ServerAdmin webmaster@localhost

    # This alias makes serving static files possible.
    #   Please note, that this is geared to our settings/common.py
    #   In production environment, you will propably adjust this!
    Alias /static/  /var/www/html/disknet_dev/disknet/static/

    # This alias makes serving media files possible.
    #   Please note, that this is geared to our settings/common.py
    #   In production environment, you will propably adjust this!
    Alias /media/  /var/www/html/disknet_dev/media/

    # Insert the full path to the wsgi.py-file here
    WSGIScriptAlias /   /var/www/html/disknet_dev/mysite/wsgi.py

    # PROCESS_NAME specifies a distinct name of this process
    #   see: https://code.google.com/p/modwsgi/wiki/ConfigurationDirectives#WSGIDaemonProcess
    # PATH/TO/PROJECT_ROOT is the full path to your project's root directory,
    #   containing your project files
    # PATH/TO/VIRTUALENV/ROOT: If you are using a virtualenv specify the full
    #   path to its directory.
    #   Generally you must specify the path to Python's site-packages.
    WSGIDaemonProcess   disknet  python-path=/var/www/html/disknet_dev:/home/admin_user/.local/share/virtualenvs/disknet_dev-hVTT6I8F/lib/python3.7/site-packages

    # PROCESS_GROUP specifies a distinct name for the process group
    #   see: https://code.google.com/p/modwsgi/wiki/ConfigurationDirectives#WSGIProcessGroup
    WSGIProcessGroup    disknet

    # Serving static files from this directory
    #   Please note, that this is geared to our settings/common.py
    #   In production environment, you will propably adjust this!
    <Directory /var/www/html/disknet_dev/disknet/static>
        Options -Indexes
        Order deny,allow
        Allow from all
    </Directory>

    # Serving media files from this directory
    #   Please note, that this is geared to our settings/common.py
    #   In production environment, you will propably adjust this!
    <Directory /var/www/html/disknet_dev/media>
        Options -Indexes
        Order deny,allow
        Allow from all
    </Directory>

    LogLevel warn

    # PROJECT_NAME is used to seperate the log files of this application
    ErrorLog    ${APACHE_LOG_DIR}/disknet_error.log
    CustomLog   ${APACHE_LOG_DIR}/disknet_access.log combined
</VirtualHost>
```
### Permissions
1. add user to same group as www-data user (and vice versa)
    - ```sudo adduser [USERNAME] www-data```
    - ```sudo adduser www-data [USERNAME]```
    - ```sudo chown [USERNAME]:www-data .local -R```
    - ```sudo chmod a+rw .local -R```
1. virtualenv für www-data user verfügbar machen
    - ```cd ~```
    - ```find ~/.local/ -type d -print0 | sudo xargs -0 chmod a+x```
1 owner of disknet directory
    - ```cd /var/www/html/```
    - ```sudo chown [USERNAME]:[USERNAME] DISKNET -R```
1. permissions for upload directory
    - ```cd DISKNET```
    - ```chmod g+w media -R```

## Tips 
- Check server disknet logs for 500 errors in /var/log/apache2/disknet_error.log (e.g. with ```$tail -f```)
- Check server logs for 500 errors in /var/log/apache2/error.log (e.g. with ```$tail -f```)
- Try restarting apache with ```$sudo services apache2 restart```
- Check process users (e.g., who runs apache) with ```ps aux | grep apache```

# Version Control
1. pull lates version to local machine
1. run local version using ```./manage.py runserver```
1. make code adjustments local code
1. push changes to feature branch
1. pull new version on development server
1. if db migrations applied: do NOT run makemigrations again. instead, only run migrate (migration commands are already in migration files)
1. check for problems on development version
1. if approved: merge feature branch with master
1. pull new master version on production server
