from django.shortcuts import render
from django.views.generic import ListView
from disknet.models import Publication
from disknet.models import Construct
from disknet.models import Relation
from disknet.models import Project
from django.shortcuts import get_object_or_404, render
from django.http import HttpResponseRedirect
from django.urls import reverse
from .forms import ConstructForm
from .forms import PublicationForm
from .forms import ProjectAddForm
from django.views import generic
from django.utils.safestring import mark_safe
from django.utils import timezone
import json

from itertools import chain


def index(request):
    form = PublicationForm()
    total_paper = len(Publication.objects.raw(
        "Select `id`, `short_cite`, `name` from `disknet_publication` where `journal` IN ('European Journal of Information Systems','Information Systems Journal','Information Systems Research','Journal of the Association for Information Systems','Journal of Information Technology','Journal of Management Information Systems','Journal of Strategic Information Systems','MIS Quarterly')"))
    total_constructs = len(Construct.objects.raw(
        "Select `id`, `name`, `publication_id` from `disknet_construct` where `publication_id` IN (Select Id from `disknet_publication` Where `journal` IN ('European Journal of Information Systems','Information Systems Journal','Information Systems Research','Journal of the Association for Information Systems','Journal of Information Technology','Journal of Management Information Systems','Journal of Strategic Information Systems','MIS Quarterly'))"))
    total_relations = len(Relation.objects.raw(
        "Select `id`, `publication_id` from `disknet_relation` where `publication_id` IN (Select Id from `disknet_publication` Where `journal` IN ('European Journal of Information Systems','Information Systems Journal','Information Systems Research','Journal of the Association for Information Systems','Journal of Information Technology','Journal of Management Information Systems','Journal of Strategic Information Systems','MIS Quarterly'))"))
    return render(request, 'disknet/index.html',
                  {'form': form, 'total_paper': total_paper, 'total_constructs': total_constructs,
                   'total_relations': total_relations, })


# Create your views here.
def construct_search_old(request):
    if request.method == 'GET':

        form = ConstructForm(request.GET)

        # check if input is valid:
        if form.is_valid():
            construct_name = request.GET.get('construct')

            # Case-insensitive containment test
            construct_list = Construct.objects.filter(name__icontains=construct_name)

            relation_from_list = Relation.objects.filter(construct_from__in=construct_list)
            relation_moderator_list = Relation.objects.filter(construct_moderator__in=construct_list)
            relation_to_list = Relation.objects.filter(construct_to__in=construct_list)

            graph_list = []

            # todo: add moderators and path coefficient to view
            for relation in list(chain(relation_from_list, relation_moderator_list, relation_to_list)):
                construct_from_name = relation.construct_from.name
                # construct_moderator_name = relation.construct_moderator.name
                construct_to_name = relation.construct_to.name

                if relation.significance == ">0.1":
                    relation_type = "insignificant"

                elif relation.path_coefficient > 0:
                    relation_type = "positive"

                else:
                    relation_type = "negative"

                relation_dict = {"source": construct_from_name, "target": construct_to_name, "type": relation_type}

                graph_list.append(relation_dict)

            save_graph_json = mark_safe(json.dumps(graph_list))

            return render(request, 'disknet/index.html',
                          {'relation_from_list': relation_from_list, 'relation_moderator_list': relation_moderator_list,
                           "relation_to_list": relation_to_list, 'form': form, 'graph_json': save_graph_json})

    else:
        form = ConstructForm()

    return render(request, 'disknet/index.html', {'form': form})


def publication_search(request):
    form = PublicationForm()

    return render(request, 'disknet/publication_search.html', {'form': form})


class ResultsView(generic.ListView):
    template_name = 'disknet/publication_search_results.html'
    context_object_name = 'publication_list'

    def get_queryset(self):
        """
        Return the last five published questions (not including those set to be
        published in the future).
        """
        publication_name = self.request.GET.get('publication')

        publication_list = Publication.objects.filter(name__icontains=publication_name).order_by("year")

        return publication_list


def publication_search_results(request):
    if request.method == 'GET':

        form = PublicationForm(request.GET)

        # check if input is valid:
        if form.is_valid():
            publication_name = request.GET.get('publication')

            publication_list = Publication.objects.filter(name__icontains=publication_name)

            project_form = ProjectAddForm(publication_list=publication_list)

            context = {'project_form': project_form, 'publication_list': publication_list}

            return render(request, 'disknet/publication_search_results.html', context)

    else:
        form = PublicationForm()
    return render(request, 'disknet/publication_search.html', {'form': form})


class PublicationDetailView(generic.DetailView):
    model = Publication
    template_name = 'disknet/publication_detail.html'
    context_object_name = 'publication'

    def get_queryset(self):
        """

        """
        return Publication.objects.filter(pub_date__lte=timezone.now())


class ConstructDetailView(generic.DetailView):
    model = Construct
    template_name = 'disknet/construct_detail.html'
    context_object_name = 'constructs'

    def get_queryset(self):
        """

        """
        return Publication.objects.filter(pub_date__lte=timezone.now())


class PublicationList(ListView):
    template_name = 'disknet/publications_list.html'
    context_object_name = 'publications'

    def get_queryset(self):
        """
        Excludes any publications that aren't assigned to current user.
        """
        # TODO: add filter to display only assigned publications
        # return Publication.objects.filter(pub_date__lte=timezone.now())

        return Publication.objects.all()


class ProjectView(generic.DetailView):
    model = Project
    template_name = "disknet/project_detail.html"

    def get_context_data(self, **kwargs):
        context = super().get_context_data(**kwargs)

        project = self.object
        # TODO: Get all Publications linked in here
        publications_list = project.publications.all()

        construct_list = Construct.objects.filter(publication__in=publications_list)

        # all_relations_list = Relation.objects.filter(publication__in=publications_list)

        relation_from_list = Relation.objects.filter(
            construct_from__in=construct_list)
        relation_moderator_list = Relation.objects.filter(
            construct_moderator__in=construct_list)
        relation_to_list = Relation.objects.filter(construct_to__in=construct_list)

        graph_list = []

        # todo: add moderators and path coefficient to view
        for relation in list(chain(relation_from_list, relation_moderator_list, relation_to_list)):
            construct_from_name = relation.construct_from.name
            # construct_moderator_name = relation.construct_moderator.name
            construct_to_name = relation.construct_to.name

            if relation.significance == ">0.1":
                relation_type = "insignificant"

            elif relation.path_coefficient > 0:
                relation_type = "positive"

            else:
                relation_type = "negative"

            relation_dict = {"source": construct_from_name,
                             "target": construct_to_name, "type": relation_type}

            graph_list.append(relation_dict)

        save_graph_json = mark_safe(json.dumps(graph_list))

        context['relation_from_list'] = relation_from_list
        context['relation_to_list'] = relation_to_list
        context['relation_moderator_list'] = relation_moderator_list
        context['relation_to_list'] = relation_to_list
        context['graph_json'] = save_graph_json
        context['relation_moderator_list'] = relation_moderator_list

        return context


def add_project(request):
    if request.method == "POST":

        # get id values from checked checkboxes
        # https://stackoverflow.com/questions/2417127/how-do-i-get-the-values-of-all-selected-checkboxes-in-a-django-request-post
        # checked_publications_ids = request.POST.getlist('publicationsCheck')
        # checked_publications = Publication.objects.filter(pk__in=checked_publications_ids)

        # todo: validate form and save model
        new_project_name = request.POST.getlist('project_name')[0]

        new_project = Project(name=new_project_name)
        new_project.save()

        for publication in checked_publications:
            new_project.publications.add(publication)

        new_project.save()

    return render(request, 'disknet/index.html')
