# Generated by Django 2.1.2 on 2019-07-26 13:48

from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Construct',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('definition', models.TextField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Item',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('text', models.CharField(max_length=250)),
                ('note', models.CharField(blank=True, default=None, max_length=250, null=True)),
                ('reverse_coded', models.NullBooleanField(default=None)),
                ('construct', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='disknet.Construct')),
            ],
        ),
        migrations.CreateModel(
            name='MetaConstruct',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('definition', models.TextField(blank=True, null=True)),
                ('name', models.CharField(max_length=200)),
                ('constructs', models.ManyToManyField(blank=True, default=None, null=True, to='disknet.Construct')),
            ],
        ),
        migrations.CreateModel(
            name='ModelImage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('image', models.ImageField(blank=True, default=None, null=True, upload_to='model_images/%Y/%m/%d', validators=[django.core.validators.FileExtensionValidator(['png', 'jpg', 'jpeg'])])),
            ],
        ),
        migrations.CreateModel(
            name='Project',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=250)),
            ],
        ),
        migrations.CreateModel(
            name='Publication',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('journal', models.CharField(blank=True, default=None, max_length=200, null=True)),
                ('year', models.IntegerField(blank=True, default=None, null=True)),
                ('volume', models.IntegerField(blank=True, default=None, null=True)),
                ('issue', models.IntegerField(blank=True, default=None, null=True)),
                ('name', models.CharField(max_length=200)),
                ('authors', models.CharField(blank=True, default=None, max_length=200, null=True)),
                ('short_cite', models.CharField(blank=True, default=None, max_length=200, null=True)),
                ('pages', models.CharField(blank=True, default=None, max_length=200, null=True)),
                ('abstract', models.TextField(blank=True, default=None, null=True)),
                ('note', models.TextField(blank=True, default=None, null=True)),
                ('relevant', models.NullBooleanField(default=None)),
                ('in_disknet', models.BooleanField(blank=True, default=False, null=True)),
                ('pdf_file', models.FileField(blank=True, default=None, null=True, upload_to='pdfs/%Y/%m/%d', validators=[django.core.validators.FileExtensionValidator(['pdf'])])),
                ('assigned_to', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Relation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('path_coefficient', models.FloatField()),
                ('significance', models.CharField(choices=[('<0.001', '<0.001'), ('<0.01', '<0.01'), ('<0.05', '<0.05'), ('<0.1', '<0.1'), ('>0.1', '>0.1')], max_length=10)),
                ('observations', models.IntegerField()),
                ('model', models.IntegerField()),
                ('construct_from', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='construct_from', to='disknet.Construct')),
                ('construct_moderator', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='construct_moderator', to='disknet.Construct')),
                ('construct_to', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='construct_to', to='disknet.Construct')),
                ('publication', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='publication', to='disknet.Publication')),
            ],
        ),
        migrations.AddField(
            model_name='project',
            name='publications',
            field=models.ManyToManyField(blank=True, default=None, null=True, to='disknet.Publication'),
        ),
        migrations.AddField(
            model_name='modelimage',
            name='publication',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='disknet.Publication'),
        ),
        migrations.AddField(
            model_name='metaconstruct',
            name='project',
            field=models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.CASCADE, to='disknet.Project'),
        ),
        migrations.AddField(
            model_name='item',
            name='publication',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='disknet.Publication'),
        ),
        migrations.AddField(
            model_name='construct',
            name='publication',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='disknet.Publication'),
        ),
    ]
