from django import forms
from django.forms import ModelForm
from disknet.models import Project, Publication
from django.forms import models
from django.forms.fields import MultipleChoiceField


# customizing the ModelChoiceField made available in Django
# to have a better control at the data being displayed in the template(s)
class AdvancedModelChoiceIterator(models.ModelChoiceIterator):
    def choice(self, obj):
        return (self.field.prepare_value(obj), self.field.label_from_instance(obj), obj)


class AdvancedModelChoiceField(models.ModelMultipleChoiceField):
    def _get_choices(self):
        if hasattr(self, '_choices'):
            return self._choices
        return AdvancedModelChoiceIterator(self)

    choices = property(_get_choices, MultipleChoiceField._set_choices)


class ProjectAddForm(forms.ModelForm):
    name = forms.CharField(label='', max_length=300)

    # using the above customized ModelChoiceField here
    publications = AdvancedModelChoiceField(
        widget=forms.CheckboxSelectMultiple,
        queryset=None,
        required=True,
        help_text='<b>Required.</b><br/>Select the problems for your problemset.'
    )

    class Meta:
        model = Project
        fields = ('name',)

    def __init__(self, *args, **kwargs):
        publication_list = kwargs.pop('publication_list')

        super(ProjectAddForm, self).__init__(*args, **kwargs)
        if publication_list:
            print(publication_list)
            self.fields['publications'].queryset = publication_list


class ConstructForm(forms.Form):
    construct = forms.CharField(label='', max_length=50)


class PublicationForm(forms.Form):
    publication = forms.CharField(label='', max_length=300,
                                  widget=forms.TextInput(attrs={'placeholder': 'publication title'}))


class ProjectAddFormOLD(forms.Form):
    project_name = forms.CharField(label='', max_length=300)
    # publications_selected = forms.ModelMultipleChoiceField(queryset=None)
    publications_available = forms.ModelMultipleChoiceField(queryset=None, widget=forms.CheckboxSelectMultiple)

    def __init__(self, *args, **kwargs):
        publication_list = kwargs.pop('publication_list')

        super(ProjectAddForm, self).__init__(*args, **kwargs)
        if publication_list:
            print(publication_list)
            self.fields['publications_available'].queryset = publication_list

    def clean_publications_available(self):
        # Todo: validate if all selected publications are in list of available publications
        pass


class ProjectDefaultForm(ModelForm):
    class Meta:
        model = Project
        fields = ["name"]
        labels = {"name": "Project Name"}
